package game;

import java.awt.Graphics;

public interface BlockInterface {

	public abstract IntRect getCollisionRect();

	public abstract boolean isPlayerSpriteBlocked(CollidableObject player);

	public abstract void draw(Graphics g, PlayerSprite player, int panelWidth,
			int panelHeight);

	public abstract void draw(Graphics g, int playerX, int playerY,
			int panelWidth, int panelHeight);

	public abstract int getxPos();

	public abstract void setxPos(int xPos);

	public abstract int getyPos();

	public abstract void setyPos(int yPos);

	public abstract void primeImage(Graphics g);

	public abstract boolean isPassThrough();

	public abstract int getCollisionRectMinY();

	public abstract int getCollisionRectMaxY();

	public abstract int getCollisionRectMinX();

	public abstract int getCollisionRectMaxX();

	public abstract int getWidth();

	public abstract int getHeight();

	public abstract boolean isPlayerCurrentlyOnBlock(PlayerSprite player);

	public abstract boolean isPlayerCurrentlyBonkedOnBlock(PlayerSprite player);

	public abstract String getName();

}